<?php

ini_set('memory_limit','128M');
set_time_limit(60*3);
mb_internal_encoding("UTF-8");
date_default_timezone_set("Asia/Hong_Kong");
error_reporting(E_ALL & ~E_NOTICE);

include("version.php");

include("common.php");
include("db.php");

function getSetting($key, $default)
{
    $result = $default;

    $dataTable = selectQuery("select top 1 SET_Value from [Settings] where SET_Key = ?" , $key);
    if (count($dataTable)>0)
    {
        if ($dataTable[0]["SET_Value"])
        {
            $result = $dataTable[0]["SET_Value"];
        }
    }

    return $result;
}

function CheckCustomerAvailableByDatabase($date, $customerID)
{
    $result = true;

    // If there is record and not closed (plog_closed=0)
    $sql = "select * from PlayLog 
            where plog_date = ? and plog_cus_auto_id = ? and plog_closed = 0";

    $dataTable = selectQuery($sql, $date, $customerID);
    if (count($dataTable)>0)
    {
        $result = false;
    }

    return $result;
}

function CheckCellAvailableByDatabase($date, $floorID, $tableKey, $columnKey)
{
    $result = true;

    $sql = "select PlayLogTime.* from PlayLogTime 
        left join PlayLog on PlayLogTime.ptime_plog_auto_id = PlayLog._auto_id
        where ptime_endtime is null
        and ptime_flr_auto_id = ? 
        and ptime_fls_key = ? 
        and ptime_key = ?
        and plog_date = ? and plog_closed = 0";

    $dataTable = selectQuery($sql, $floorID, $tableKey, $columnKey, $date);
    if (count($dataTable)>0)
    {
        $result = false;
    }

    return $result;
}

function GetCustomerLogData($date, $customerID)
{
    $result = "";

    $sql = "select PlayLog.*
        , PlayLogTime._auto_id as ptime_auto_id
        , ptime_starttime
        , ptime_endtime
        , ptime_flr_auto_id
        , ptime_fls_key
        , ptime_key
        , ptime_remark
        , ptime_type
        , ptime_amount
        , ptime_prg_auto_id
        , ptime_cust_percent
        , PlayLogTime._auto_id as logtime_auto_id
        , DATEDIFF( minute, ptime_starttime, ptime_endtime ) as time_diff
        , (ptime_fls_key + '.' + ptime_key) as fullkey
        , Customer.cus_code, Customer.cus_name, Customer.cus_gender, Customer.cus_othername
        , FloorPlanSection.fls_caption
        , FloorPlan.flr_caption, FloorPlan.flr_key
        , plp_type, plp_amount, plp_amount2, plp_prg_auto_id
        , prg_name, prg_forecolor, prg_backcolor, prg_key
        , PlayLogDevice.dev_number
        from PlayLog 
        left join PlayLogTime on PlayLogTime.ptime_plog_auto_id = PlayLog._auto_id
        left join Customer on Customer._auto_id = PlayLog.plog_cus_auto_id
        left join FloorPlanSection on FloorPlanSection.fls_flr_auto_id = ptime_flr_auto_id and FloorPlanSection.fls_key = ptime_fls_key
        left join PlayPrice on PlayPrice.plp_fls_auto_id = FloorPlanSection._auto_id
        left join PlayPriceGrid on PlayPriceGrid._auto_id = PlayLogTime.ptime_prg_auto_id
        left join FloorPlan on FloorPlan._auto_id = PlayLog.plog_flr_auto_id
        left join PlayLogDevice on PlayLogDevice.dev_id = PlayLogTime._auto_id and PlayLogDevice.dev_type='PlayLogTime'

        where plog_date = ? and plog_cus_auto_id = ?
        
        order by ptime_starttime, ptime_endtime, PlayLogTime._auto_id";

    $dataTable = selectQuery($sql, $date, $customerID);
    if (count($dataTable)>0)
    {
        $result = $dataTable;
    }

    return $result;
}

function getCustomerLogTranData($date, $customerID)
{
    $result = "";

    $sql = "
            select PlayLog._auto_id, PlayLog.plog_date, PlayLog.plog_number
                    ,PlayLogTran._auto_id as playlogtran_auto_id
                    ,PlayLogTran.ptran_plog_auto_id
                    ,PlayLogTran.ptran_prod_auto_id
                    ,PlayLogTran.ptran_index
                    ,PlayLogTran.ptran_name
                    ,PlayLogTran.ptran_price
                    ,PlayLogTran.ptran_qty
                    ,PlayLogTran.ptran_paid
                    ,PlayLogTran.ptran_total_hour
                    ,PlayLogTran.ptran_remark
                    ,PlayLogTran.ptran_usr_auto_id
                    ,PlayLogTran.ptran_datetime
                    ,PlayLogTran.ptran_inv_auto_id
                    ,PlayLogTran.ptran_price_ori
                    ,PlayLogTran.ptran_ptime_auto_id
                    ,isnull(Product.pro_name,'') as prod_name
                    ,Product.pro_name
                    ,PlayPriceGrid.prg_name
                    ,PlayLogDevice.dev_number
                    from PlayLog 
                    inner join PlayLogTran on PlayLogTran.ptran_plog_auto_id = PlayLog._auto_id
                    left join Product on Product._auto_id = PlayLogTran.ptran_prod_auto_id

                    left join PlayLogTime on PlayLogTime._auto_id = PlayLogTran.ptran_ptime_auto_id
                    left join PlayPriceGrid on PlayPriceGrid._auto_id = PlayLogTime.ptime_prg_auto_id

                    left join PlayLogDevice on PlayLogDevice.dev_id = PlayLogTran._auto_id and PlayLogDevice.dev_type='PlayLogTran'

                    where plog_date = ? and plog_cus_auto_id = ?
                    order by plog_date, plog_number, ptran_datetime, ptran_index
    ";

    // order by plog_date, plog_number desc, prod_name, ptran_ptime_auto_id, ptran_index

    $dataTable = selectQuery($sql, $date, $customerID);
    if (count($dataTable)>0)
    {
        $result = $dataTable;
    }

    return $result;
}

function getGridPrice($sectionID)
{
    $result = "";

    $sql = "select PlayPriceGrid.* 
                from PlayPrice
                left join PlayPriceGrid on PlayPriceGrid._auto_id = PlayPrice.plp_prg_auto_id
                where PlayPrice.plp_fls_auto_id = ?
            ";

    $dataTable = selectQuery($sql, $sectionID);
    if (count($dataTable)>0)
    {
        $result = $dataTable;
    }

    return $result;
}

function skipNumber($number)
{
    $result = $number;

    $result = str_replace("4", "5", $result);
    $result = str_replace("7", "8", $result);

    return $result;
}


function getNextNumber($date, $floorAutoID)
{
    $result = 1;

    // If there is record and not closed (plog_closed=0)
    $sql = "select isnull(max(plog_number),0) as max_number from PlayLog where plog_date = '$date' and plog_flr_auto_id = $floorAutoID";

    $dataTable = selectQuery($sql);
    if (count($dataTable)>0)
    {
        $result = $dataTable[0]["max_number"] + 1;
    }

    $result = skipNumber($result);

    return $result;
}

function UpdatePlayTimeIP($playTimeAutoID, $key, $remark)
{
    $result = "";

    $sql = "INSERT INTO [PlayLogTimeLog]
                    ([tlog_ptime_auto_id]
                    ,[tlog_ip]
                    ,[tlog_timestamp]
                    ,[tlog_usr_auto_id]
                    ,[tlog_key]
                    ,[tlog_remark])
                VALUES
                    (?
                    ,?
                    ,?
                    ,?
                    ,?
                    ,?)";

    $ip = $_SERVER['REMOTE_ADDR'];
    $dateTime = date("Y-m-d H:i:s");
    $userID = -1;

    $error = executeQuery($sql
        , $playTimeAutoID
        , $ip
        , $dateTime
        , $userID
        , $key
        , $remark
    );

    if (!$error)
    {
        $result = true;
    }

    return $result;
}

function saveDeviceInfo($id, $type, $deviceNo)
{
    $sql = "INSERT INTO [PlayLogDevice]
            ([dev_id]
            ,[dev_type]
            ,[dev_number]
            ,[dev_ip]
            ,[dev_timestamp])
            VALUES
            (?
            ,?
            ,?
            ,?
            ,?)";

    $ip = $_SERVER['REMOTE_ADDR'];
    $dateTime = date("Y-m-d H:i:s");

    $error = executeQuery($sql
        , $id
        , $type
        , $deviceNo
        , $ip
        , $dateTime
    );

    return $error;

}

?>