<?php

session_start();

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

ini_set('memory_limit','128M');
set_time_limit(60*3);
mb_internal_encoding("UTF-8");
date_default_timezone_set("Asia/Hong_Kong");

include("lib.php");

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, user-scalable=0">
    <title>麻雀館手機系統</title>
    <link rel="icon" type="image/png" size="24" data-hid="favicon-24" href="icon.png">

    <script src="js/html5-qrcode.min.js"></script>
    <script src="js/jquery.min.js"></script>
    <script src="js/common.js?v=<?php echo randomString(5); ?>"></script>

    <!-- Bootstrap and Bootstrap Flat -->
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="css/bootstrap-flat.min.css" rel="stylesheet">
	
    <!-- BEGIN GLOBAL MANDATORY STYLES -->
    <link rel="stylesheet" type="text/css" href="assets/css/MegaNavbar.css"/>
    <link rel="stylesheet" type="text/css" href="assets/css/skins/navbar-inverse.css" title="inverse">
    <link rel="stylesheet" type="text/css" href="assets/css/animation/animation.css" title="inverse">

<style>

body { padding:5px; font-size:14px; }
.page-container { width:100%; }

.page-head { 
    padding:5px; 
    font-size:20px; 
    font-weight: bold; 
    margin-bottom: 5px; 
    text-align: center; 
    display: flex;
    flex-direction: row;
    justify-content: space-between;
    align-items: center;
    flex-wrap: nowrap;
    background-color: #204d74;
    color: white;
    margin:-5px -5px 5px -5px;
}

.page-head #device {
    cursor: pointer;
}

.page-head > div {
    flex:1;
}

.page-content {  }
.page-reader { height:250px; width:300px; margin:0px auto;}
#reader { width:100%; }

.dialog-background {display:none;}

.dialog-background.active { 
    display:flex; 
    position:fixed; 
    top:0px; 
    left:0px; 
    right:0px; 
    bottom:0px; 
    background-color: rgb(0 0 0 / 80%); 
    z-index: 110;
    flex-direction: row;
    align-content: center;
    justify-content: center;
    align-items: center;
 }
.dialog-container { min-height:200px; background-color: white; flex: 1; margin: 20px; padding:10px; }
.dialog-content { font-size:22px; }
.dialog-content .dialog-title { font-size:30px; text-align: center; margin-bottom:10px; }
.dialog-content table {width: 100%;}
.dialog-content table tr {border-bottom: 1px solid;}
.dialog-content table td {padding:3px;}
.dialog-content table td.caption {min-width:100px;}
.dialog-content table td.value {text-align: center; white-space: nowrap;}
.dialog-content .dialog-command {display: flex; margin-top: 20px;}
.dialog-content .dialog-confirm {width:100%; flex:2; font-size: 28px;}
.dialog-content .dialog-cancel {width:100%; flex:1; font-size: 28px; margin-left: 5px;}

.page-message { width:100%; padding:0px; text-align:center; }
.page-message .title {font-weight: bold;font-size: 20px; padding:3px;}
.page-message .message {font-weight: bold;font-size: 20px; padding:3px;}
.page-message .message { display:block; top:45%; left:0px; right:0px; position:fixed; padding:10px 5px; }

.page-command { 
    width:100%; padding: 0px;
    display: flex;
    justify-content: space-around;
    align-content: center;
}
.page-command .page-command-scan { text-align:center; }

.page-command .page-command-reader,
.page-command .page-command-info,
.page-command .page-command-device {
    display: flex;
    justify-content: center;
    flex-wrap: nowrap;
    align-items: center;
    width: 100%;
 }

 .page-command button {
     flex: 1;
     font-size: 24px;
 }

.page-info { 
    font-size:18px;
    margin-bottom: 50px;
}

.page-customer, .page-table, .page-action {
    text-align: center; 
    display: flex;
    flex-direction: row;
    justify-content:flex-start;
    align-items: center;
    flex-wrap: nowrap;
}

.page-customer-button {
    display: flex;
    flex-direction: column;
    justify-content:flex-start;
    align-items: center;
    flex-wrap: nowrap;
}

.page-customer-button .btn {
    margin-top:3px;
}
.page-customer-button .btn:first-child {
    margin-top:0px;
}

.page-customer .btn, .page-table .btn, .page-action .btn {
    padding: 20px 10px;
    font-size:20px;
    margin-right: 10px;
}

.page-action .page-customer-button { align-self: flex-start; }

#customer, #table { text-align: center; font-size: 20px; flex: 1;}
#customer span, #table span { display:inline-block; margin-left:3px; margin-right:3px; }

#log { flex: 1; align-self: self-start; display:flex;}
#log table { width:100%; border:0px; margin-bottom:20px; }
#log table td { padding:3px; }
#log table thead {font-weight: bold;}
#log table .log-table-no { text-align: left; }
#log table .log-table-start { min-width: 60px; }
#log table .log-table-end { min-width: 60px; }
#log table .log-table-item { text-align: left; min-width: 60px; }
#log table .log-table-amount { text-align:right; min-width: 60px; }
#log table .log-table-total { font-size:1.2em; }


#price { flex: 1; align-self: self-start; margin-bottom: 300px;}
#price .price-row,
#price .price-head {
    display: flex;
    flex-wrap: wrap;
    justify-content: center;
    align-items: center;
    flex-direction: row;
    font-size: 24px;
    text-align: center;
    width:100%;
}
#price .price-item {
    width:33.33333%;
    padding-top:5px;
    padding-bottom:5px;
    border: 5px solid white;
    font-size: 24px;
}

#price .price-input,
#price .price-button {
    display: flex;
    flex-direction: row;
    flex-wrap: nowrap;
    justify-content: center;
    align-items: center;
    align-content: center;
    width: 100%;
    margin-bottom:10px;
}

#price .price-caption {
    flex:1;
    margin: 0px 0px 5px 0px;
    width:50%;
}
#price .price-value {
    flex:1;
    margin: 0px 0px 5px 0px;
    width:50%;
    font-size: 28px;
    text-align: center;
    border: 1px solid;
}
#price .price-type {
    flex:1;
    width:50%;
    margin:0px 5px 0px 5px;
    padding:5px;
    border: 1px solid #eea236;
}
#price .price-confirm {
    flex:1;
    width:50%;
    margin:0px 5px 0px 5px;
    padding:5px;
    border: 1px solid #4cae4c;
}

#price .price-add,
#price .price-qty,
#price .price-deduct
{
    flex:1;
    width:33%;
    margin:0px 5px 0px 5px;
    padding:5px;
    border: 1px solid;
}

#price .price-footer {
    padding-left: 5px;
    padding-right: 5px;
    width: 100%;
}

#price textarea.price-remark {
    width:100%;
}

#price .price-percent-container {
    display: flex;
    flex-direction: row;
    justify-content: center;
    align-items: center;
    flex-wrap: wrap;
}

#price .price-percent-container input {
    width:33%;
    text-align: center;
}

#price .price-percent-container div {
    margin-left:10px;
    margin-right:10px;
}

.section-page {display:none !important;}
.section-page.active {display:block !important;}

#datetime { text-align: center; font-size:16px; }

.footer { position: fixed; bottom: 0px; width: 100%; z-index: 100; left: 0px; right: 0px; background-color: white; border-top: 1px solid black;}

.btn { font-size:18px; }

.color-red {color:#d9534f;}
.no-record {
    font-size:20px;
    text-align: center;
    align-self: center;
    justify-self: center;
    flex: 1;
}

hr {border-bottom:1px solid black; margin:5px 0px; }

@media (max-width: 900px) {
    .page-reader { width:100%; }

}

/* Start by setting display:none to make this hidden.
   Then we position it in relation to the viewport window
   with position:fixed. Width, height, top and left speak
   for themselves. Background we set to 80% white with
   our animation centered, and no-repeating */
   .modal {
    display:    none;
    position:   fixed;
    z-index:    1000;
    top:        0;
    left:       0;
    height:     100%;
    width:      100%;
    background: rgba( 255, 255, 255, .8 ) 
                url('img/loading.gif') 
                50% 50% 
                no-repeat;
}

/* When the body has the loading class, we turn
   the scrollbar off with overflow:hidden */
body.loading .modal {
    overflow: hidden;   
}

/* Anytime the body has the loading class, our
   modal element will be visible */
body.loading .modal {
    display: block;
}

body.show-keypad .modal-number {
    overflow: hidden;
    display: flex;
}
body.show-cust-input .modal-cust-input {
    overflow: scroll;
    display: flex;
}

.modal-number
,.modal-cust-input {
    display:    none;
    position:   fixed;
    z-index:    1000;
    top:        0;
    left:       0;
    height:     100%;
    width:      100%;
    background: rgb(33 33 33 / 90%);
    justify-content: center;
    align-items: center;    
}
.number-container
,.cust-input-container {
    display: flex;
    width: 300px;
    margin: 0px auto;
    justify-content: space-evenly;
    align-items: center;
    flex-wrap: wrap;
}
.cust-input-container {
    width:100%;
    padding:20px;
}
.modal-cust-input {
    align-items: flex-start;
}

.number-row
,.cust-input-row
,.device-input-row {
    display: flex;
    width: 100%;
    justify-content: space-evenly;
}
.number-key {
    font-size:22px;
    border:1px solid;
    padding:20px;
    flex: 1;
    text-align: center;
    margin: 3px;
}
.number-value {
    background-color: white;
    font-size: 30px;
    padding: 10px;
}

.cust-input-caption
,.cust-input-value
{
    font-size:22px;
    padding:5px;
    flex: 1;
    text-align: center;
    margin: 3px;
    color:white;
}

.cust-input-value input {
    color:black;
}

.cust-input-caption {
    text-align: left;
    padding-left:0px;
    /* margin-left:-10px; */
    color:white;
    margin-left: 10px;
    margin-right: 10px;
}

.cust-input-value input {
    width:80%;
    padding:5px;
}

.cust-input-value input[type=radio] {
    width: auto;
}

.cust-input-label { 
    color:white; 
    font-weight: normal;
    margin-left: 20px;
}

.cust-input-confirm button {
    width:100%;
    padding:5px;
    margin-top:0px;
}

.cust-input-cancel button {
    width:100%;
    padding:5px;
    margin-top:0px;
}

.cust-input-confirm { 
    flex:2;
}
.cust-input-cancel { 
    flex:1;
}

.cust-feature-list {
    color:white;
}

.cust-group-container, .cust-feature-container {
    display: flex;
    flex-direction: row;
    flex-wrap: wrap;
    justify-content: space-around;
    width:100%;
}

.cust-feature-item {
    flex:1;
    margin: 5px;
    padding: 5px;
    min-width: 80px;
    text-align: center;
    background-color: #364966;
    cursor:pointer;
}

.cust-group-container .cust-feature-item {
    background-color: #376636;
}

.cust-feature-container {
    /*
    max-height: 200px;
    */
    overflow: auto;
}

.device-input-value {
    font-size:22px;
    padding:5px;
    flex: 1;
    text-align: left;
    margin: 3px;
    color:black;
    justify-self: flex-start;
    align-self: center;
}

.device-input-caption { 
    flex: 1;
    justify-self: flex-end;
    align-self: center;
    text-align: right;
    font-size: 22px;
}

.device-invalid {
    background-color: #c9302c;
    padding:10px;
}

</style>

</head>
<body>

<div class="page-container">
    <div class="page-content">

        <div class="page-head">
            <div id='header'></div>
            <div id='device'><div class="device-no"></div></div>
            <div id='datetime' class='cur-datetime'></div>
        </div>

        <!-- Scan Page  -->
        <div class="page-reader">
            <div id='reader'></div>
            <?php
                if ($_REQUEST["debug"]==1)
                {
                    echo "<div style='width:100%;'><input class='qrcode-input' style='width:100%;'></div>";
                }
            ?>
        </div>

        <!-- Customer Page  -->
        <div class="page-info" style="display:none;">

            <div class="page-customer">
                <div class="page-customer-button">
                    <button class="btn btn-success" onclick="showPage('reader','customer');">掃瞄客號</button>
                </div>
                <div id='customer'></div>
            </div>
            <hr/>
            
            <div class="page-table">
                <button class="btn btn-primary" onclick="showPage('reader','table');">掃瞄新枱</button>
                <div id='table'></div>
            </div>
            <hr/>

            <div class="page-action">
                <div class="page-customer-button">
                    <button class="btn btn-warning btn-customer-log" onclick="showSection('log');">記錄</button>
                    <button class="btn btn-warning btn-customer-add" onclick="">新客</button>
                    <button class="btn btn-warning btn-customer-checkin" onclick="getPrice('price_init','利是','埋枱','addLog');">埋枱</button>
                    <button class="btn btn-warning btn-customer-move" onclick="getPrice('price_init','利是','轉枱','moveLog');">轉枱</button>
                    <button class="btn btn-warning btn-product-add" onclick="getProduct('貨品','買野','');">買野</button>
                </div>
                <div id='log' class="section-page active"></div>
                <div id='price' class="section-page"></div>
            </div>
            <hr/>
            
        </div>

        <!-- Device Page  -->
        <div class="page-device" style="display:none;">
            <div id='device-info'>
                <div class="device-input-row">
                    <div class="device-input-caption" >編號:</div>
                    <div class="device-input-value" > <input name="device-number" id="device-number" placeholder="請輸入裝置編號"></div>
                </div>

                <div class="device-input-row">
                    <div class="device-input-caption" >密碼:</div>
                    <div class="device-input-value" ><input type="password" name="device-pass" id="device-pass"></div>
                </div>

            </div>
        </div>

    </div>
    <div class="footer">
        <div class="page-message"><div class="message" style="display:none;"></div><div class="title"></div></div>
        <div class="page-command">
            <!-- Scan Page  -->
            <div class="page-command-reader">
                <button class="btn btn-success command-scan" onclick='camStart(cameraId);'>重啟掃瞄</button>
                <button class="btn btn-warning command-show-info" onclick='showPage("info");'>顯示資料</button>
            </div>

            <!-- Info Page -->
            <div class="page-command-info" style="display:none;">
                <button class="btn btn-danger command-clear" onclick='clearData();'>清除資料</button>
            </div>

            <!-- Device Page  -->
            <div class="page-command-device" style="display:none;">
                <button class="btn btn-success command-device-save" onclick='saveDeviceID();'>儲存</button>
                <button class="btn btn-warning command-show-info" onclick='showPage("info");'>反回主頁</button>
            </div>
        </div>
    </div>
</div>

<div class='dialog-background'>
    <div class='dialog-container'>
        <div class='dialog-content'>
            <div class='dialog-title'></div>
            <div class='dialog-message'></div>
            <div class='dialog-command'>
                <button class='btn btn-primary dialog-confirm'>確定</button>
                <button class='btn btn-danger dialog-cancel' onclick='closeDialog();'>取消</button>
            </div>
        </div>
    </div>
</div>

<input type="hidden" id='result'>
<div class="modal"><!-- Place at bottom of page --></div>

<div class="modal-cust-input">
    <div class="cust-input-container">
        <!--
        <div class="cust-input-row">
            <div class="cust-input-caption" >名稱</div>
        </div>
        -->
        <div class="cust-input-row">
            <div class="cust-input-value" >名稱: <input name="cust-input-name" id="cust-input-name" placeholder="請輸入名稱"></div>
        </div>
        <!--
        <div class="cust-input-row">
            <div class="cust-input-caption" >特徵</div>
        </div>
        -->
        <div class="cust-input-row">
            <div class="cust-input-value" >特徵: <input name="cust-input-feature" id="cust-input-feature" placeholder="請輸入特徵"></div>
        </div>
        <div class="cust-input-row">
            <div class="cust-input-value" ><input name="cust-input-gender" id="cust-input-male" type="radio" value="0"><label for="cust-input-male" class="cust-input-label">男</label></div>
            <div class="cust-input-value" ><input name="cust-input-gender" id="cust-input-female" type="radio" value="1"><label for="cust-input-female" class="cust-input-label">女</label></div>
        </div>
        <div class="cust-input-row">
            <div class="cust-input-value cust-input-confirm" >
                <button class="btn-success">儲存</button>
            </div>
            <div class="cust-input-value cust-input-cancel" >
                <button class="btn-danger">關閉</button>
            </div>
        </div>
        <div class="cust-input-row">
            <div class="cust-input-value" ><div class="cust-feature-list"></div></div>
        </div>
    </div>
</div>

<div class="modal-number">
    <div class="number-container">
        <div class="number-row">
            <div class="number-key number-value" data-result=0 >0</div>
        </div>
        <div class="number-row">
            <button class="number-key btn-primary" data-value="1" >1</button>
            <button class="number-key btn-primary" data-value="2" >2</button>
            <button class="number-key btn-primary" data-value="3" >3</button>
        </div>
        <div class="number-row">
            <button class="number-key btn-primary" data-value="4" >4</button>
            <button class="number-key btn-primary" data-value="5" >5</button>
            <button class="number-key btn-primary" data-value="6" >6</button>
        </div>
        <div class="number-row">
            <button class="number-key btn-primary" data-value="7" >7</button>
            <button class="number-key btn-primary" data-value="8" >8</button>
            <button class="number-key btn-primary" data-value="9" >9</button>
        </div>
        <div class="number-row">
            <button class="number-key btn-primary number-toggle" >+/-</button>
            <button class="number-key btn-primary" data-value="0" >0</button>
            <button class="number-key number-clear btn-warning" data-fixed="0" >清除</button>
        </div>
        <div class="number-row">
            <button class="number-key number-confirm btn-success">確定</button>
        </div>

    </div>
</div>

<script>

// This method will trigger user permissions
var cameraId = 0;
var html5QrCode;
var cameraStarted = false;
var host = "";

// Scanned Info
var floorID = -1; // The current floorplan id
var customerInfo = ""; // Show the customer information
var logInfo = ""; // Show the log information
var tableInfo = ""; // Show the table information

Html5Qrcode.getCameras().then(cameras => {
      /**
        * devices would be an array of objects of type:
        * { id: "id", label: "label" }
       */
       if (cameras && cameras.length) {
           
           if (cameras[1])
               cameraId = cameras[1].id;
            else   
               cameraId = cameras[0].id;
               
            // .. use this to start scanning.
            
            // alert('cam:' + cameraId);
            
            camStart(cameraId);
        }
   }).catch(err => {
        // handle err
        alert(err);
}); 

function camStart(id, type="") {
    
    showMessage("");

    if (type=="log")
    {
        showTitle("請掃 埋枱號");
    }
    else if (type=="customer")
    {
        showTitle("請掃 客號");
    }
    else if (type=="table")
    {
        showTitle("請掃 枱號");
    }
    else if (type=="product")
    {
        showTitle("請掃 貨號");
    }
    else
    {
        showTitle("請掃 枱號/客號/埋枱號");
    }

    // Stop cam first
    camStop();

    // Create instance of the object.
    // The only argument is the “id” of HTML element created above.
    html5QrCode = new Html5Qrcode('reader');
    html5QrCode.start(
       id, // retreived in the previous step.
       {
          fps: 10,    // sets the framerate to 10 frame per second 
          qrbox: 300  // sets only 250 X 250 region of viewfinder to
                      // scannable, rest shaded.
     },
     qrCodeMessage => {
         // do something when code is read. For example:
         //console.log(`QR Code detected: ${qrCodeMessage}`);
         $('#result').val(qrCodeMessage);
         
         var value = scanQRCode(qrCodeMessage, type);
        
     },
     errorMessage => {
         // parse error, ideally ignore it. For example:
         //console.log(`QR Code no longer in front of camera.`);
         // showMessage("掃瞄發生錯誤: " + err, "red");
     })
     .catch(err => {
         // Start failed, handle it. For example, 
        // console.log(`Unable to start scanning, error: ${err}`);

        showMessage("掃瞄發生錯誤: " + err, "red");
     });
     
     // html5QrCode.render(onScanSuccess);

     cameraStarted = true;
    
     // Adjust the height
     // $(".page-reader").css("height", $(".page-reader video").height() + "px");
}

function camStop()
{
    if (cameraStarted)
    {
        cameraStarted = false;

        html5QrCode.stop();
        html5QrCode.clear();
    }

    showMessage("");
}

function clearData()
{
    customerInfo = "";
    logInfo = "";
    tableInfo = "";

    $("#price .price-row").remove();

    refreshInfo();

    showPage('reader');
}

function getTypeName(type)
{
    if (type=="log")
    {
        return "埋枱號";
    }
    else if (type=="customer")
    {
        return "客號";
    }
    else if (type=="table")
    {
        return "枱號";
    }
    else if (type=="product")
    {
        return "貨號";
    }

    return "";
}

function closeDialog()
{
    $(".dialog-background").removeClass("active");

    $(".dialog-title").html("");
    $(".dialog-message").html("");
}

function showDialog(title, message, confirmText, confirmEvent, confirmData)
{
    $(".dialog-title").html(title);
    $(".dialog-message").html(message);

    $(".dialog-background").addClass("active");

    $(".dialog-confirm").off("click");

    $(".dialog-confirm").click(function() {

        if (confirmEvent)
            confirmEvent(confirmData);
    });
}

function showMessage(message, color="blue")
{
    // Always error message

    if (message)
    {
        $(".page-message .message").show();
    }
    else
    {
        $(".page-message .message").hide();
    }

    $(".page-message .message").css("background-color", "#742029");
    $(".page-message .message").css("color", "white");
    $(".page-message .message").html(message);
}

function showTitle(message, color="blue")
{
    $(".page-message .title").css("background-color", "#204d74");
    $(".page-message .title").css("color", "white");
    $(".page-message .title").text(message);
}

function refreshInfo()
{
    $("#customer").html("");
    $("#table").html("");
    $("#log").html("");

    // Customer
    if (customerInfo)
    {
        $("#customer").append( $("<span class='cust-gender'>").text("(" + ((customerInfo.cus_gender==0)?"男":"女") + ") ") );
        if (customerInfo.cus_name) $("#customer").append( $("<span class='cust-name'>").text(customerInfo.cus_name) );
        if (customerInfo.cus_code) $("#customer").append( $("<span class='cust-code'>").text(" (" + customerInfo.cus_code + ")") );

        // if (customerInfo.cus_othername) $("#customer").append( $("<span class='cust-othername'>").text("(" + customerInfo.cus_othername + ")") );
        // if (customerInfo.prg_name) $("#customer").append("<span class='cust-price'>(" + customerInfo.prg_name + ")</span>");

        if (customerInfo.available) 
            $("#customer").append("<div class='cust-available'>(未埋枱)</div>");
        else
        {
            if (customerInfo.log)
            {
                var tableHtml = "<div>";

                var lastLog = customerInfo.log.at(-1);

                // Table
                tableHtml += "<div class='cust-table'>"+lastLog.flr_caption + " - " + lastLog.fls_caption + " [" + lastLog.ptime_key+"]</div>";

                // Time
                if (lastLog.ptime_starttime)
                {
                    var startTime = new Date(lastLog.ptime_starttime.date);
                    
                    var time = String(startTime.getHours()).padStart(2, '0') + ":" + String(startTime.getMinutes()).padStart(2, '0');

                    tableHtml += "<div class='cust-time'>("+time+")</div>";
                }
                // flr_caption - FloorPlan Name

                tableHtml += "</div>";
                
                $("#customer").append(tableHtml);

            }

        }
    }
    else
    {
        $("#customer").append("<span class='color-red'>[沒有客戶]</span>");
    }

    // Log
    if (customerInfo && customerInfo.log)
    {
        var logHtml = "<table>";

        logHtml += "<thead>";
        logHtml += "<tr>";
        logHtml += "<td class='log-table-no'>枱號</td>";
        logHtml += "<td class='log-table-start'>開始</td>";
        logHtml += "<td class='log-table-end'>結束</td>";
        logHtml += "</tr>";
        logHtml += "</thead>";

        logHtml += "<tbody>";
        $.each(customerInfo.log, function( index, value ) {
            
            logHtml += "<tr>";
            // + " : " + value.ptime_key +
            logHtml += "<td class='log-table-no'>"+value.plog_number+". "+value.flr_caption + " - " + value.fls_caption + " [" + value.ptime_key +"]<br/>";
            if (value.dev_number) logHtml += "[" + value.dev_number + "] ";
            logHtml += "利是: " + Math.round(value.ptime_amount);
            logHtml += "</td>";

            // Time
            if (value.ptime_starttime)
            {
                var startTime = new Date(value.ptime_starttime.date);
                
                var time = String(startTime.getHours()).padStart(2, '0') + ":" + String(startTime.getMinutes()).padStart(2, '0');

                logHtml += "<td>"+time+"</td>";
            }
            else
            {
                logHtml += "<td> - </td>";
            }

            if (value.ptime_endtime)
            {
                var endTime = new Date(value.ptime_endtime.date);
                
                var time = String(endTime.getHours()).padStart(2, '0') + ":" + String(endTime.getMinutes()).padStart(2, '0');

                logHtml += "<td>"+time+"</td>";
            }
            else
            {
                logHtml += "<td> - </td>";
            }

            logHtml += "</tr>";

        });

        logHtml += "</tbody>";
        logHtml += "</table>";

        // Show the transaction
        if (customerInfo.tran)
        {
            logHtml += "<table>";

            logHtml += "<thead>";
            logHtml += "<tr>";
            logHtml += "<td class='log-table-item'>項目</td>";
            logHtml += "<td class='log-table-start'>時間</td>";
            logHtml += "<td class='log-table-amount'>金額</td>";
            logHtml += "</tr>";
            logHtml += "</thead>";

            logHtml += "<tbody>";
            
            var totalTran = 0;

            $.each(customerInfo.tran, function( index, value ) {
                
                // Product Only, <= 0 is not a product
                if (value.ptran_prod_auto_id <= 0) return;

                logHtml += "<tr>";
                // + " : " + value.ptime_key +
                logHtml += "<td class='log-table-item'>";
                logHtml += value.plog_number+". ";
                if (value.dev_number) logHtml += "[" + value.dev_number + "] ";
                logHtml += value.prod_name;
                logHtml += "</td>";

                // Time
                if (value.ptran_datetime)
                {
                    var startTime = new Date(value.ptran_datetime.date);
                    
                    var time = String(startTime.getHours()).padStart(2, '0') + ":" + String(startTime.getMinutes()).padStart(2, '0');

                    logHtml += "<td>"+time+"</td>";
                }
                else
                {
                    logHtml += "<td> - </td>";
                }

                var amount = value.ptran_qty * value.ptran_price;

                totalTran += amount;

                logHtml += "<td class='log-table-amount'>"+amount+"</td>";

                logHtml += "</tr>";
            });

            logHtml += "<tr>";
            logHtml += "<td class='log-table-item'></td>";
            logHtml += "<td></td>";
            logHtml += "<td class='log-table-amount log-table-total'><hr>" + totalTran + "</td>";
            logHtml += "</tr>";

            logHtml += "</tbody>";
            logHtml += "</table>";
        }


        $("#log").append(logHtml);
    }
    else
    {
        $("#log").append("<div class='color-red no-record'>[沒有記錄]</div>");
    }

    // Table
    if (tableInfo)
    {
        if (tableInfo.flr_caption) $("#table").append("<span class='floor-name'>" + tableInfo.flr_caption + "</span>");
        if (tableInfo.fls_caption) $("#table").append("<span class='table-name'> - " + tableInfo.fls_caption + "</span>");
        if (tableInfo.column) $("#table").append("<span class='table-column'>[" + tableInfo.column + "]</span>");
        if (tableInfo.prg_name) $("#table").append("<span class='table-price'>(" + tableInfo.prg_name + ")</span>");

        if (tableInfo.available)
            $("#table").append("<div class='table-available'>(可用)</div>");
        else
        {
            // 
            $("#table").append("<div class='table-available'>(已埋枱)</div>");
        }
    }
    else
    {
        $("#table").append("<span class='color-red'>[沒有枱號]</span>");
    }

    // Refresh Button
    if (customerInfo)
    {
        // Has customer
        $(".btn-customer-log").show();
        $(".btn-customer-add").hide();
        $(".btn-customer-checkin").hide();
        $(".btn-customer-move").hide();
        $(".btn-product-add").hide();

        if (customerInfo.available) // 未埋枱
        {
            if (tableInfo && tableInfo.available)
                $(".btn-customer-checkin").show();
        }
        else
        {
            if (tableInfo && tableInfo.available)
                $(".btn-customer-move").show(); // 轉枱

            $(".btn-product-add").show();
        }
    }
    else
    {
        // No customer
        $(".btn-customer-log").hide();
        $(".btn-customer-add").show();
        $(".btn-customer-checkin").hide();
        $(".btn-customer-move").hide();
        $(".btn-product-add").hide();
    }
    
}

function showPage(page, camType="")
{
    $(".page-reader").hide();
    $(".page-command-reader").hide();
    $(".page-info").hide();
    $(".page-command-info").hide();
    $(".title").hide();
    $('.page-device').hide();
    $(".page-command-device").hide();

    if (page=="reader") 
    {
        $(".page-reader").show();
        $(".page-command-reader").show();
        $(".title").show();

        camStart(cameraId, camType);
    }
    else if (page=="info") 
    {
        camStop();

        $(".page-info").show();
        $(".page-command-info").show();
    }
    else if (page=="device") 
    {
        camStop();

        var id = getDeviceID();
        
        if (id)
            $('input#device-number').val(id);
        else
            $('input#device-number').val("");

        $(".page-device").show();
        $(".page-command-device").show();
    }

    showSection("log");
}

function showSection(section)
{
    $(".section-page.active").removeClass("active");
    $("#"+section+".section-page").addClass("active");
}

function scanQRCode(code, checkType)
{
    var result = "";
    var desc = "";
    var showPage = true;
    var date = "";
    var message = "";

    showMessage("");

    try
    {
        const obj = JSON.parse(code);
        
        if (obj.date)
        {
            var curDate = (new Date()).Format("yyyy-MM-dd");
            if (obj.date != curDate)
            {
                message = "<br/>QR Code 已經無效！";
                showPage = false;
            }
        }

        if (checkType)
        {
            if (checkType == obj.type)
            {
                result = obj.val;
            }
            else
            {
                showMessage("不是 " + getTypeName(checkType) + " QR Code", "red");
                showPage = false;
            }
        }
        else
        {
            checkType = obj.type;
            result = obj.val;
        }
        
        // Show Page
        if (showPage && checkType && result)
        {
            if (checkType=="log")
            {
                checkLog(result);
            }
            else if (checkType=="customer")
            {
                checkCustomer(result);
            }
            else if (checkType=="table")
            {
                checkTable(result);
            }
            else if (checkType=="product")
            {
                checkProduct(result);
            }
        }
        else
        {
            showMessage("不是有效的 " + getTypeName(checkType) + " QR Code。" + message, "red");
        }
    }
    catch (error)
    {
        showMessage("錯誤的 QR Code: " + error, "red");
    }

    return result;
}

function checkLog(id)
{
    // Check log and then show customer and log
    alert("log:" + id);
}

function checkCustomer(id)
{
    // Check customer and then show customer and log
    //alert("cust:" + id);

    $("body").addClass("loading");

    customerInfo = "";

    $.ajax({
        method: "POST",
        url: host + "checkCustomer.php",
        dataType: "json",
        data: { customerid: id }
    })
    .always(function() {

        $("body").removeClass("loading");

    })
    .fail(function(e) {
        
    })
    .done(function( msg ) {
        
        if (msg.error)
        {
            alert(msg.error + ": " + id);
        }
        else
        {
            customerInfo = msg;

            refreshInfo();

            showPage("info");
        }

    });

}

function getCompany()
{
    // Check customer and then show customer and log
    //alert("cust:" + id);

    $("body").addClass("loading");

    $.ajax({
        method: "POST",
        url: host + "getCompany.php",
        dataType: "json",
        data: { }
    })
    .always(function() {
        $("body").removeClass("loading");
    })
    .fail(function(e) {
        
    })
    .done(function( msg ) {
        
        if (msg.company)
        {
            $("#header").text(msg.company);
        }

    });

}

function getProduct(caption, buttonCaption, actionPage)
{
    // Check customer and then show customer and log
    //alert("cust:" + id);

    $("#price .price-row").remove();

    $("body").addClass("loading");

    $.ajax({
        method: "POST",
        url: host + "getProduct.php",
        dataType: "json",
        data: { }
    })
    .always(function() {
        $("body").removeClass("loading");
    })
    .fail(function(e) {
        
    })
    .done(function( msg ) {
        
        // Show the price input panel
        var row = $("<div class='price-row'>");
        
        var header = $("<div class='price-head'>");
        var input = $("<div class='price-input'><span class='price-caption'>" + caption + "</span><button class='price-value btn-primary' name='price-value'>0</button></div>");
        var buttonType = $("<button class='price-type btn-warning'>公司應付</button>");
        var buttonConfirm = $("<button class='price-confirm btn-success'>" + buttonCaption + "</button>");

        var buttonAdd = $("<button class='price-add btn-warning'>+</button>");
        var buttonQty = $("<button class='price-qty btn-warning'>1</button>");
        var buttonDeduct = $("<button class='price-deduct btn-warning'>-</button>");

        var buttonGroup = $("<div class='price-button'>");
        $(buttonGroup).append(buttonConfirm);
        $(buttonGroup).append(buttonType);

        var buttonGroup2 = $("<div class='price-button'>");
        $(buttonGroup2).append(buttonAdd);
        $(buttonGroup2).append(buttonQty);
        $(buttonGroup2).append(buttonDeduct);

        $(header).append(input);
        $(header).append(buttonGroup);
        $(header).append(buttonGroup2);

        $(row).append(header);

        if (Array.isArray(msg.product))
        {
            $.each(msg.product, function(index, value)
            {
                var item = $("<button class='price-item btn-primary'>");
                $(item).text(value.pro_name);
                $(item).attr("data-val", value._auto_id);
                $(item).attr("data-code", value.pro_code);

                var price = parseInt(value.pro_price);
                $(item).attr("data-price", price?price:0);

                $(row).append(item);
            });

            $("#price").append(row);

        }

        var footer = $("<div class='price-footer'>");

        $(footer).append("<div class='price-remark-container'><textarea class='price-remark' name='price-remark' placeholder='備註'></textarea></div>")
        // $(footer).append("<div class='price-percent-container'><input type='number' placeholder='客份數' class='price-customer' name='price-customer' onkeypress='return event.charCode >= 48 && event.charCode <= 57'><div>/</div><input type='number' placeholder='公份數' class='price-company' name='price-company' onkeypress='return event.charCode >= 48 && event.charCode <= 57'></div>")

        $(row).append(footer);

        // 公司應付 +
        // 客戶應付 -        
    
        // $(buttonType).attr("data-type", "customer");
        $(buttonType).attr("data-type", "company");
        $(buttonType).attr("color-default-customer", "red");
        $(buttonType).attr("color-default-company", "green");

        if (msg.color_customerpay) $(buttonType).attr("color-customer", getHexColor(msg.color_customerpay));
        if (msg.color_companypay) $(buttonType).attr("color-company", getHexColor(msg.color_companypay));
        if (msg.color_customerpaytext) $(buttonType).attr("text-customer", msg.color_customerpaytext);
        if (msg.color_companypaytext) $(buttonType).attr("text-company", msg.color_companypaytext);
        
        if (actionPage)
        {
            $("#price .price-confirm").attr("data-action", actionPage);
        }

        refreshPriceType();

        addProductEvent();
        
        showSection("price");

    });

}

function getPrice(priceKey, caption, buttonCaption, actionPage)
{
    // Check customer and then show customer and log
    //alert("cust:" + id);

    $("#price .price-row").remove();

    $("body").addClass("loading");

    $.ajax({
        method: "POST",
        url: host + "getPrice.php",
        dataType: "json",
        data: { key: priceKey }
    })
    .always(function() {
        $("body").removeClass("loading");
    })
    .fail(function(e) {
        
    })
    .done(function( msg ) {
        
        // Show the price input panel
        var row = $("<div class='price-row'>");
        
        var header = $("<div class='price-head'>");
        var input = $("<div class='price-input'><span class='price-caption'>" + caption + "</span><button class='price-value btn-primary' name='price-value' >0</button></div>");
        var buttonType = $("<button class='price-type btn-warning'>公司應付</button>");
        var buttonConfirm = $("<button class='price-confirm btn-success'>" + buttonCaption + "</button>");

        var buttonGroup = $("<div class='price-button'>");
        $(buttonGroup).append(buttonConfirm);
        $(buttonGroup).append(buttonType);

        $(header).append(input);
        $(header).append(buttonGroup);

        $(row).append(header);

        if (Array.isArray(msg.price))
        {
            $.each(msg.price, function(index, value)
            {
                var item = $("<button class='price-item btn-primary'>");
                $(item).text(value);
                $(item).attr("data-val", value);

                $(row).append(item);
            });

            $("#price").append(row);

        }

        var footer = $("<div class='price-footer'>");

        $(footer).append("<div class='price-remark-container'><textarea class='price-remark' name='price-remark' placeholder='備註'></textarea></div>")
        $(footer).append("<div class='price-percent-container'><input type='number' placeholder='客份數' class='price-customer' name='price-customer' onkeypress='return event.charCode >= 48 && event.charCode <= 57'><div>/</div><input type='number' placeholder='公份數' class='price-company' name='price-company' onkeypress='return event.charCode >= 48 && event.charCode <= 57'></div>")

        $(row).append(footer);

        // 公司應付 +
        // 客戶應付 -        
    
        $(buttonType).attr("data-type", "company");
        $(buttonType).attr("color-default-customer", "red");
        $(buttonType).attr("color-default-company", "green");

        if (msg.color_customerpay) $(buttonType).attr("color-customer", getHexColor(msg.color_customerpay));
        if (msg.color_companypay) $(buttonType).attr("color-company", getHexColor(msg.color_companypay));
        if (msg.color_customerpaytext) $(buttonType).attr("text-customer", msg.color_customerpaytext);
        if (msg.color_companypaytext) $(buttonType).attr("text-company", msg.color_companypaytext);
        
        if (actionPage)
        {
            $("#price .price-confirm").attr("data-action", actionPage);
        }

        if (tableInfo)
        {
            // Hide section if table is not 利是
            // Or the same table
            if (tableInfo.fls_type != 1
                ||
                checkCustomerSameTable())
            {
                $("#price .price-input").hide();
                $("#price .price-type").hide();
                $("#price .price-item").hide();
                $("#price .price-percent-container").hide();
            }
        }

        refreshPriceType();

        addPriceEvent();
        
        showSection("price");

    });

}

function addProductEvent()
{
    $("#price .price-type").click(function()
    {
        var type = $(this).attr("data-type");

        if (type=="customer")
            $(this).attr("data-type","company");
        else if (type=="company")
            $(this).attr("data-type","customer");

        refreshPriceType();
    });

    $("#price .price-value").click(function()
    {
        var value = $("#price .price-value").text();
        
        $(".number-value").attr("data-result", parseInt(value));
        $(".number-value").text(formatNumner(value));

        $(".number-value").attr("data-start", "1");
        if (parseInt(value) > 0)
            $(".number-value").attr("data-sign", "+");
        else if (parseInt(value) < 0)
            $(".number-value").attr("data-sign", "-");

        // Update the value
        $(".number-value").off("DOMSubtreeModified");
        $(".number-value").on("DOMSubtreeModified", function(){
            $("#price .price-value").text($(".number-value").attr("data-result"));
        });

        $("body").addClass("show-keypad");

    });
    
    $("#price .price-qty").click(function()
    {
        $("#price .price-qty").text(1);
    });

    $("#price .price-add").click(function()
    {
        var qty = parseInt($("#price .price-qty").text()) + 1;

        $("#price .price-qty").text(qty);
    });

    $("#price .price-deduct").click(function()
    {
        var qty = parseInt($("#price .price-qty").text()) - 1;

        if (qty <= 0) qty = 1;

        $("#price .price-qty").text(qty);
    });

    $("#price .price-item").click(function() {
        var value = $(this).attr("data-val");
        var price = $(this).attr("data-price");
        var caption = $(this).text();

        $("#price .price-caption").text(caption);
        $("#price .price-value").attr("data-id", value);
        $("#price .price-value").attr("data-ori-price", price);
        $("#price .price-value").text(price);

        // $("#price .price-confirm").click();
    });
    
    $("#price .price-confirm").click(function(){
        
        // When confirm, show the confirm dialog
        showProductConfirmDialog();

    });

}

function addPriceEvent()
{
    $("#price .price-type").click(function()
    {
        var type = $(this).attr("data-type");

        if (type=="customer")
            $(this).attr("data-type","company");
        else if (type=="company")
            $(this).attr("data-type","customer");

        refreshPriceType();
    });

    $("#price .price-value").click(function()
    {
        var value = $("#price .price-value").text();
        
        $(".number-value").attr("data-result", parseInt(value));
        $(".number-value").text(formatNumner(value));

        $(".number-value").attr("data-start", "1");
        if (parseInt(value) > 0)
            $(".number-value").attr("data-sign", "+");
        else if (parseInt(value) < 0)
            $(".number-value").attr("data-sign", "-");

        // Update the value
        $(".number-value").off("DOMSubtreeModified");
        $(".number-value").on("DOMSubtreeModified", function(){
            $("#price .price-value").text($(".number-value").attr("data-result"));
        });

        $("body").addClass("show-keypad");

    });

    $("#price .price-item").click(function() {
        var value = $(this).attr("data-val");

        $("#price .price-value").text(value);

        $("#price .price-confirm").click();
    });
    
    $("#price .price-confirm").click(function(){
        
        // When confirm, show the confirm dialog
        showPriceConfirmDialog();

    });

}

function showPriceConfirmDialog()
{
    var data = {};
    var title = $(".price-confirm").text();
    var message = "<table>";
    message += "<tbody>";

    var cust = "";
    var table = "";
    var custlog = "";

    if (customerInfo)
    {
        if (customerInfo.cus_code) cust += "<span class='cust-code'>" + customerInfo.cus_code + " - </span>";
        if (customerInfo.cus_name) cust += "<span class='cust-name'>" + customerInfo.cus_name + "</span>";
        if (customerInfo.cus_othername) cust += "<span class='cust-othername'>(" + customerInfo.cus_othername + ")</span>";

        message += "<tr>";
        message += "<td class='caption'>客戶︰</td>";
        message += "<td class='value'>" + cust + "</td>";
        message += "</tr>";

        data["cust_auto_id"] = customerInfo._auto_id;
        data["cus_code"] = customerInfo.cus_code;
        data["cus_name"] = customerInfo.cus_name;
        data["cus_othername"] = customerInfo.cus_othername;

        if (customerInfo.log)
        {
            var lastLog = customerInfo.log.at(-1);

            if (lastLog)
            {
                if (lastLog.flr_caption) custlog += "<span class='floor-name'>" + lastLog.flr_caption + "</span>";
                if (lastLog.fls_caption) custlog += "<span class='table-name'> - " + lastLog.fls_caption + "</span>";
                if (lastLog.ptime_key) custlog += "<span class='table-column'>[" + lastLog.ptime_key + "]</span>";

                message += "<tr>";
                message += "<td class='caption'>舊枱號︰</td>";
                message += "<td class='value'>" + custlog + "</td>";
                message += "</tr>";
            }
        }

    }

    if (tableInfo)
    {
        if (tableInfo.flr_caption) table += "<span class='floor-name'>" + tableInfo.flr_caption + "</span>";
        if (tableInfo.fls_caption) table += "<span class='table-name'> - " + tableInfo.fls_caption + "</span>";
        if (tableInfo.column) table += "<span class='table-column'>[" + tableInfo.column + "]</span>";

        message += "<tr>";
        message += "<td class='caption'>新枱號︰</td>";
        message += "<td class='value'>" + table + "</td>";
        message += "</tr>";

        data["floorplan_auto_id"] = tableInfo.fls_flr_auto_id;
        data["section_auto_id"] = tableInfo._auto_id;
        data["table_key"] = tableInfo.fls_key;
        data["column_key"] = tableInfo.column;
        data["section_type"] = tableInfo.fls_type;
    }

    if ($("#price .price-row").html())
    {
        // Has price selection
        // 公司應付 +
        // 客戶應付 -        

        // Value
        data["amount"] = parseInt($(".price-value").text());
        if (!data["amount"]) data["amount"] = 0;

        data["amount_type"] = $(".price-type").attr("data-type");

        // 客戶應付 -  
        if (data["amount_type"]=="customer") data["amount"] = Math.abs(data["amount"]) * -1;

        message += "<tr>";
        message += "<td class='caption'>" + $(".price-caption").text() + "︰</td>";
        message += "<td class='value'>" + data["amount"] + "</td>";
        message += "</tr>";

        // Type
        message += "<tr>";
        message += "<td class='caption'>應付︰</td>";
        message += "<td class='value'>" + $(".price-type").text() + "</td>";
        message += "</tr>";

        // Remark
        data["remark"] = $(".price-remark").val();

        if (data["remark"])
        {
            message += "<tr>";
            message += "<td class='caption'>備註︰</td>";
            message += "<td class='value'>" + data["remark"] + "</td>";
            message += "</tr>";
        }

        // Percent
        if ($(".price-customer").val()
            &&
            $(".price-company").val())
        {
            data["percent"] = $(".price-customer").val().trim() + '/' + $(".price-company").val().trim();

            message += "<tr>";
            message += "<td class='caption'>份數︰</td>";
            message += "<td class='value'>" + data["percent"] + "</td>";
            message += "</tr>";
        }
    }

    message += "<tr>";
    message += "<td class='caption'>時間︰</td>";
    message += "<td class='value'><div class='cur-datetime'>" + $("#datetime").text() + "</div></td>";
    message += "</tr>";

    message += "</tbody>";
    message += "</table>";


    showDialog(title, message, title, function(msg) {

        var page = $("#price .price-confirm").attr("data-action");

        addPlayLog(msg, page + ".php");

    }, data);
}

function showProductConfirmDialog()
{
    var data = {};
    var title = $(".price-confirm").text();
    var message = "<table>";
    message += "<tbody>";

    var cust = "";
    var table = "";
    var custlog = "";

    if (customerInfo)
    {
        if (customerInfo.cus_code) cust += "<span class='cust-code'>" + customerInfo.cus_code + " - </span>";
        if (customerInfo.cus_name) cust += "<span class='cust-name'>" + customerInfo.cus_name + "</span>";
        if (customerInfo.cus_othername) cust += "<span class='cust-othername'>(" + customerInfo.cus_othername + ")</span>";

        message += "<tr>";
        message += "<td class='caption'>客戶︰</td>";
        message += "<td class='value'>" + cust + "</td>";
        message += "</tr>";

        data["cust_auto_id"] = customerInfo._auto_id;
        data["cus_code"] = customerInfo.cus_code;
        data["cus_name"] = customerInfo.cus_name;
        data["cus_othername"] = customerInfo.cus_othername;

        if (customerInfo.log)
        {
            var lastLog = customerInfo.log.at(-1);

            if (lastLog)
            {
                if (lastLog.flr_caption) custlog += "<span class='floor-name'>" + lastLog.flr_caption + "</span>";
                if (lastLog.fls_caption) custlog += "<span class='table-name'> - " + lastLog.fls_caption + "</span>";
                if (lastLog.ptime_key) custlog += "<span class='table-column'>[" + lastLog.ptime_key + "]</span>";

                message += "<tr>";
                message += "<td class='caption'>枱號︰</td>";
                message += "<td class='value'>" + custlog + "</td>";
                message += "</tr>";
            }
        }

    }

    if ($("#price .price-row").html())
    {
        // Has price selection
        // 公司應付 +
        // 客戶應付 -        

        data["amount_type"] = $(".price-type").attr("data-type");
        data["product_id"] = $(".price-value").attr("data-id");
        data["product_name"] = $(".price-caption").text();

        // Value
        data["amount"] = parseInt($(".price-value").text());
        data["amount_ori"] = parseInt($(".price-value").attr("data-ori-price"));
        if (!data["amount"]) data["amount"] = 0;

        // 客戶應付 -  
        if (data["amount_type"]=="customer") data["amount"] = Math.abs(data["amount"]) * -1;

        data["qty"] = parseInt($(".price-qty").text());
        if (!data["qty"]) data["qty"] = 1;

        data["total"] = data["amount"] * data["qty"];

        // Mobile Only
        // If 公司應付, it will the cost
        var itemExtraCaption = "";
        if (data["amount_type"]=="company")
        {
            itemExtraCaption = " ($" + Math.abs(data["total"]) + ")";

            data["product_name"] += itemExtraCaption;
            data["amount"] = 0;
            data["total"] = 0;
        }

        message += "<tr>";
        message += "<td class='caption'>貨品︰</td>";
        message += "<td class='value'>" + $(".price-caption").text() + itemExtraCaption + "</td>";
        message += "</tr>";

        message += "<tr>";
        message += "<td class='caption'>金額︰</td>";
        message += "<td class='value'>" + data["amount"] + " x " + data["qty"] + "</td>";
        message += "</tr>";

        message += "<tr>";
        message += "<td class='caption'>總金額︰</td>";
        message += "<td class='value'>" + data["total"] + "</td>";
        message += "</tr>";

        // Type
        message += "<tr>";
        message += "<td class='caption'>應付︰</td>";
        message += "<td class='value'>" + $(".price-type").text() + "</td>";
        message += "</tr>";

        // Remark
        data["remark"] = $(".price-remark").val() + itemExtraCaption;

        if (data["remark"])
        {
            message += "<tr>";
            message += "<td class='caption'>備註︰</td>";
            message += "<td class='value'>" + data["remark"] + "</td>";
            message += "</tr>";
        }

    }

    message += "<tr>";
    message += "<td class='caption'>時間︰</td>";
    message += "<td class='value'><div class='cur-datetime'>" + $("#datetime").text() + "</div></td>";
    message += "</tr>";

    message += "</tbody>";
    message += "</table>";


    showDialog(title, message, title, function(msg) {

        addPlayLog(msg, "addProduct.php");

    }, data);
}

function refreshPriceType()
{
    var button = $("#price .price-type");
    var type = $(button).attr("data-type");
    var text = $(button).attr("text-" + type);
    var color = $(button).attr("color-" + type);
    var colorDefault = $(button).attr("color-default-" + type);

    $(button).text(text);
    $(button).css("background-color", (color?color:colorDefault));
    $(button).css("border-color", (color?color:colorDefault));
}

function addPlayLog(dataValue, page)
{
    if (!hasDeviceID())
    {
        alert("裝置未設定編號！");
        return;
    }

    $("body").addClass("loading");

    dataValue["deviceno"] = getDeviceID();
    
    $.ajax({
        method: "POST",
        url: host + page,
        dataType: "json",
        data: dataValue
    })
    .always(function() {
        $("body").removeClass("loading");
    })
    .fail(function(e) {
        
        // alert(e.message);

    })
    .done(function( msg ) {
        
        if (msg.error)
        {
            alert(msg.error);
        }
        else
        {
            alert(msg.success);
            
            closeDialog();
            clearData();
        }

    });
}

function updateCustomer(dataValue)
{
    $("body").addClass("loading");
    
    dataValue["deviceno"] = getDeviceID();

    $.ajax({
        method: "POST",
        url: host + "updateCustomer.php",
        dataType: "json",
        data: dataValue
    })
    .always(function() {
        $("body").removeClass("loading");
    })
    .fail(function(e) {
        
        // alert(e.message);

    })
    .done(function( msg ) {
        
        if (msg.error)
        {
            alert(msg.error);
        }
        else
        {
            customerInfo.cus_name = dataValue["cus_name"];
            customerInfo.cus_code = dataValue["cus_othername"];
            customerInfo.cus_othername = dataValue["cus_othername"];
            customerInfo.cus_gender = dataValue["cus_gender"];

            alert(msg.success);

            $("body").removeClass("show-cust-input");

            refreshInfo();
        }

    });
}

function checkTable(id)
{
    // Check table and then show add customer page
    
    $("body").addClass("loading");
    
    tableInfo = "";

    $.ajax({
        method: "POST",
        url: host + "checkTable.php",
        dataType: "json",
        data: { tableid: id }
    })
    .always(function() {
        $("body").removeClass("loading");
    })
    .fail(function(e) {
        
    })
    .done(function( msg ) {
        
        if (msg.error)
        {
            alert(msg.error + ": " + id);
        }
        else
        {
            tableInfo = msg;

            refreshInfo();

            showPage("info");
        }

    });

}

function hasDeviceID()
{
    if (getDeviceID())
        return true;
    else
        return false;
}

function getDeviceID()
{
    var id = localStorage.getItem('deviceID');

    if (id)
        return id;
    else
        return "";
}

function saveDeviceID()
{
    var id = $('input#device-number').val();
    var p = $('input#device-pass').val();
    
    saveDeviceIDMain(id, p);
}

function saveDeviceIDMain(id, p)
{
    // Check table and then show add customer page
    
    $("body").addClass("loading");
    
    tableInfo = "";

    $.ajax({
        method: "POST",
        url: host + "checkPass.php",
        dataType: "json",
        data: { pass: p }
    })
    .always(function() {
        $("body").removeClass("loading");

        $('input#device-pass').val("");
    })
    .fail(function(e) {
        
    })
    .done(function( msg ) {
        
        if (msg.error)
        {
            alert(msg.error);
        }
        else
        {
            localStorage.setItem('deviceID',id);

            clearData();

            alert("裝置號碼已儲存。");
        }

    });

}

function checkProduct(id)
{
    alert("product:" + id);
    
}

function getDateTime()
{
    // Check customer and then show customer and log
    //alert("cust:" + id);

    $.ajax({
        method: "POST",
        url: host + "getDateTime.php",
        dataType: "json",
        data: { }
    })
    .fail(function(e) {
        
        $(".cur-datetime").html("<span style='color:#ffacac;'>未能連接伺服器</span>");

    })
    .done(function( msg ) {
        
        if (msg.dateTime)
        {
            $(".cur-datetime").text(msg.dateTime);
        }
        else
        {
            $(".cur-datetime").text("-");
        }

    })
    .always(function() {

        // Check Device ID
        var devieID = getDeviceID();
        if (devieID)
        {
            $("#device .device-no").removeClass("device-invalid");
            $("#device .device-no").text("[" + devieID + "]");
        }
        else
        {
            $("#device .device-no").addClass("device-invalid");
            $("#device .device-no").text("[沒有編號]");
        }

        setTimeout(() => {
                getDateTime();
            }, 1000);

    });

}

function getFeatureList()
{
    $(".cust-feature-list").html("");

    $.ajax({
        method: "POST",
        url: host + "getFeatures.php",
        dataType: "json",
        data: { }
    })
    .fail(function(e) {
        
        

    })
    .done(function( result ) {

        var groupObject = $("<div class='cust-group-container'>");

        if (result.group)
        {
            $(result.group).each(function(index, value){
                
                var newItem = $("<div class='cust-feature-item'>");
                $(newItem).attr("data-id", value.id);
                $(newItem).text(value.name);

                $(groupObject).append(newItem);

            });
        }

        $(".cust-feature-list").append(groupObject);

        var featureObject = $("<div class='cust-feature-container'>");

        if (result.feature)
        {
            $(result.feature).each(function(index, value){
                
                var newItem = $("<div class='cust-feature-item'>");
                $(newItem).attr("data-id", value.id);
                $(newItem).attr("data-group-id", value.group);
                $(newItem).text(value.name);

                $(featureObject).append(newItem);

            });
        }

        $(".cust-feature-list").append(featureObject);

        // Add Event
        $(".cust-group-container .cust-feature-item").click(function(){

            var groupID = $(this).attr("data-id");

            if (groupID == -1)
            {
                $(".cust-feature-container .cust-feature-item").show();
            }
            else
            {
                $(".cust-feature-container .cust-feature-item").hide();
                $(".cust-feature-container .cust-feature-item[data-group-id=" + groupID + "]").show();
            }

        });

        $(".cust-feature-container .cust-feature-item").click(function(){
            
            var value = $(this).text();

            $("#cust-input-feature").val(value);
            $("#cust-input-feature").focus();

        });


    })
    .always(function() {

    });

}

function addKeyPadEvent()
{
    $(".number-key").click(function(){

        var value = $(this).attr("data-value");
        var valueFixed = $(this).attr("data-fixed");
        var curValue = $(".number-value").attr("data-result");
        var resultValue = curValue;

        if (value)
        {
            if ($(".number-value").attr("data-start") == "1")
            {
                // First time key in
                resultValue = value;

                if ($(".number-value").attr("data-sign")=="-")
                {
                    resultValue = Math.abs(resultValue) * -1;
                }
                else if ($(".number-value").attr("data-sign")=="+")
                {
                    resultValue = Math.abs(resultValue);
                }
            }
            else
            {
                if (curValue == 0)
                {
                    resultValue = value;
                }
                else
                {
                    resultValue = parseInt(curValue.trim() + value.trim());
                }
            }
        }
        else if (valueFixed)
        {
            resultValue = valueFixed;
        }
        else
        {
            if ($(this).hasClass("number-close"))
            {
                $("body").removeClass("show-keypad");
                $(".number-value").off("DOMSubtreeModified");
            }
            else if ($(this).hasClass("number-confirm"))
            {
                $("body").removeClass("show-keypad");
                $(".number-value").off("DOMSubtreeModified");
            }
            else if ($(this).hasClass("number-clear"))
            {
                resultValue = 0;
            }
            else if ($(this).hasClass("number-toggle"))
            {
                resultValue = resultValue * -1;

                if (resultValue==0) resultValue=0;
            }
            
        }

        // Alreay key in
        $(".number-value").attr("data-start","");
        $(".number-value").attr("data-sign","");

        $(".number-value").attr("data-result", resultValue);
        $(".number-value").text(formatNumner(resultValue));

        $(this).focusout();
    })

}

function checkCustomerSameTable()
{
    var result = false;

    if (customerInfo
        &&
        tableInfo)
    {
        if (!customerInfo.available
            &&
            customerInfo.log) 
        {
            var lastLog = customerInfo.log.at(-1);
            
            if (tableInfo.fls_flr_auto_id == lastLog.ptime_flr_auto_id
                &&
                tableInfo.fls_key == lastLog.ptime_fls_key)
            {
                result = true;
            }
        }
    }

    return result;
}

$(document).ready(function(){

    getCompany();

    getDateTime();

    getFeatureList();

    refreshInfo();

    $(".page-message .message").click(function()
    {
        // Click to hide
        $(".page-message .message").hide();
    });

    addKeyPadEvent();

    $("#customer").click(function(){

        if (customerInfo)
        {
            $("input#cust-input-name").val(customerInfo.cus_name);
            $("input#cust-input-feature").val(customerInfo.cus_code);

            if (customerInfo.cus_gender==0)
            {
                $("input#cust-input-male").prop("checked", true);
            }
            else if (customerInfo.cus_gender==1)
            {
                $("input#cust-input-female").prop("checked", true);
            }

            $("body").addClass("show-cust-input");
        }

    });

    $(".cust-input-cancel button").click(function() {
        $("body").removeClass("show-cust-input");
    })

    $(".cust-input-confirm button").click(function() {
        
        var dataValue = {};
        dataValue["cust_auto_id"] = customerInfo._auto_id;
        dataValue["cus_name"] = $("#cust-input-name").val();
        dataValue["cus_othername"] = $("#cust-input-feature").val();

        if ($("input#cust-input-male").prop("checked"))
            dataValue["cus_gender"] = 0;
        else if ($("input#cust-input-female").prop("checked"))
            dataValue["cus_gender"] = 1;

        updateCustomer(dataValue);

    })

    $("#device .device-no").click(function() {
        // Show the page to update device id
        showPage("device");

    })

    $(".qrcode-input").keypress(function(event)
    {
        if ( event.which == 13 ) {

            scanQRCode( $(this).val() , "");

            event.preventDefault();
        }
    });

    

});

</script>

</body>

</html>
