<?php

include("config.php");

function openDatabase()
{
	// global $db_hostname, $db_username, $db_password, $db_database;

	$serverName = DB_HOST;
	$connectionInfo = array( "Database"=>DB_DATABASE, "UID"=>DB_USER, "PWD"=>DB_PASS, "CharacterSet" => "UTF-8");
	$conn = sqlsrv_connect( $serverName, $connectionInfo);

    if (!$conn) {
        echo "Failed to connect to MSSQL: " . sqlsrv_errors();
    }
    else
    {
        return $conn;
    }
}

function executeQuery($query, ...$params)
{
    $err = "";
    
	$serverName = DB_HOST;
	$connectionInfo = array( "Database"=>DB_DATABASE, "UID"=>DB_USER, "PWD"=>DB_PASS, "CharacterSet" => "UTF-8");
	$conn = sqlsrv_connect( $serverName, $connectionInfo);

	$options =  array( "Scrollable" => SQLSRV_CURSOR_FORWARD); // SQLSRV_CURSOR_KEYSET

	$result = sqlsrv_query( $conn, $query, $params, $options);   
	
	$err = sqlsrv_errors();

	sqlsrv_close($conn);

    if ($err)
	   return $err;
    else
        return "";
}

function executeQueryReturnID($query, ...$params)
{
	$id = -1;
	$err = "";
    
	$serverName = DB_HOST;
	$connectionInfo = array( "Database"=>DB_DATABASE, "UID"=>DB_USER, "PWD"=>DB_PASS, "CharacterSet" => "UTF-8");
	$conn = sqlsrv_connect( $serverName, $connectionInfo);

	$options =  array( "Scrollable" => SQLSRV_CURSOR_FORWARD ); // SQLSRV_CURSOR_KEYSET

	$result = sqlsrv_query( $conn, $query, $params, $options);   
	
	$err = sqlsrv_errors();

	// Get AutoID
	$result = sqlsrv_query( $conn, "SELECT @@identity");
	
	sqlsrv_fetch($result); 
	$id = sqlsrv_get_field($result, 0);	

	sqlsrv_close($conn);
	
	return $id;
}

function selectQuery($query, ...$params)
{	
	$resultFinal = array();
    $err = "";
    
	$serverName = DB_HOST;
	$connectionInfo = array( "Database"=>DB_DATABASE, "UID"=>DB_USER, "PWD"=>DB_PASS, "CharacterSet" => "UTF-8");
	$conn = sqlsrv_connect( $serverName, $connectionInfo);

	$options =  array( "Scrollable" => SQLSRV_CURSOR_FORWARD); // SQLSRV_CURSOR_KEYSET

	$result = sqlsrv_query( $conn, $query, $params, $options);   
	
	$err = sqlsrv_errors();

	while( $row = sqlsrv_fetch_array($result, SQLSRV_FETCH_ASSOC) ) {
		$resultFinal[] = $row;
	}

	sqlsrv_close($conn);
	
	return $resultFinal;
}

/*
function selectQuery($sql)
{
    mssql_connect(DB_HOST, DB_USER, DB_PASS);
    mssql_select_db(DB_DATABASE);

    $result = array();
    $dataTable = mssql_query($sql);
    while ( $record = mssql_fetch_array($dataTable) )
    {
        $result[] = $record;
        // echo $record["col1"] .", ". $record["col2"] ."<br />";
    }

    return $result;
}

function executeQuery($sql)
{
    mssql_connect(DB_HOST, DB_USER, DB_PASS);
    mssql_select_db(DB_DATABASE);

    return mssql_query($sql);
}

*/


?>