<?php

// 2021-06-04
function escape($str) {
	return str_replace('\\', '%', substr(json_encode($str), 1, -1));
}

function unescape($str) {
	return json_decode('"'.str_replace('%', '\\', $str).'"');
}


function isIE()
{
    if (isset($_SERVER['HTTP_USER_AGENT']) &&
    (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== false))
        return true;
    else
        return false;
}

function replaceHTML($source)
{
	return htmlentities($source, ENT_QUOTES, 'UTF-8');
}

function decodeHTML($source)
{
	return html_entity_decode($source, ENT_QUOTES, 'UTF-8');
}

function replaceEscape($value)
{
	return str_replace("'", "\'", $value);
}

function isValue($value)
{
	if (isset($value))
	{
		if ($value == "")
			return false;
		else
			return true;
	}
	else
		return false;

}

function replaceQuote($source)
{
	return str_replace('\'','\\\'',str_replace('\\','\\\\',$source));
}

function replaceFunctionQuote($source)
{
	return str_replace('\'','\'\'',$source);
}

function replaceCR($source)
{
	//return str_replace("\r","",str_replace("\n",'<br />', $source));
	return str_replace("\r","\\r",str_replace("\n",'\\n', $source));
}

function replaceCR2BR($source)
{
	return str_replace("\r","",str_replace("\n",'<br />', $source));
}

function trimString($source, $len)
{
	if (mb_strlen($source) > $len)
	{
		return mb_substr($source,0,$len)."...";
	}
	else
	{
		return $source;
	}

}

function formatDateTime($date, $format, $default="")
{
	if ($date)
		return date_format(new DateTime($date),$format);
	else
		return $default;
}

function right($value, $count){
    return substr($value, ($count*-1));
}

function left($string, $count){
    return substr($string, 0, $count);
}

function goBack()
{
	header('Location: '.$_SERVER['HTTP_REFERER']);
}

function redirURL($clear)
{
	if ($_SESSION['pre_url'])
	{
		$url = $_SESSION['pre_url'];

		if ($clear) $_SESSION['pre_url'] = '';

		header('Location: '.$url);
	}
	else
	{
		// header(__BASEURL__);
	}
}

function getPageDomain()
{
	$pageURL = 'http';
	if ($_SERVER["HTTPS"] == "on") {$pageURL .= "s";}
	$pageURL .= "://";
	if ($_SERVER["SERVER_PORT"] != "80") {
	 $pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"];
	} else {
	 $pageURL .= $_SERVER["SERVER_NAME"];
	}
	return $pageURL;
}

function curPageURL() {
 $pageURL = 'http';
 if ($_SERVER["HTTPS"] == "on") {$pageURL .= "s";}
 $pageURL .= "://";
 if ($_SERVER["SERVER_PORT"] != "80") {
  $pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
 } else {
  $pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
 }
 return $pageURL;
}

function curPageURLByQuery($query) {
 $pageURL = 'http';
 if ($_SERVER["HTTPS"] == "on") {$pageURL .= "s";}
 $pageURL .= "://";
 if ($_SERVER["SERVER_PORT"] != "80") {
  $pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].'/'.$query;
 } else {
  $pageURL .= $_SERVER["SERVER_NAME"].'/'.$query;
 }
 return $pageURL;
}

function sendMail($to, $subject, $contents, $from, $html = false, $cc = "", $bcc = "")
{
	if ($html)
	{
		$from_header = 'MIME-Version: 1.0' . "\r\n";
		$from_header .= 'Content-type: text/html; charset=utf-8' . "\r\n";
		$from_header .= "From: $from". "\r\n";
	}
	else
	{
		$from_header = "From: $from". "\r\n";
	}

	if ($cc)
		$from_header .= "Cc:".$cc. "\r\n";

	if ($bcc)
		$from_header .= "Bcc:".$bcc. "\r\n";

	if($contents != "")
	{
		if (!$subject)
			$subject = "";

		//send mail - $subject & $contents come from surfer input
		mail($to, $subject, $contents, $from_header);
	}

}

function sendSmtpMail($to, $subject, $contents, $from, $html = false, $cc = "", $bcc = "")
{
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

	$headers = array ('From' => $from, 'To' => $to, 'Subject' => $subject, 'Reply-To' => $from);

	if ($html)
	{
		$headers["MIME-Version"] = "1.0";
		$headers["Content-type"] = "text/html; charset=utf-8";
	}

	if ($cc)
		$headers["Cc"] = $cc;

	if ($bcc)
		$headers["Bcc"] = $bcc;

	try
	{
		/*
		require_once("Mail.php");

		$smtp = Mail::factory('smtp', array ('host' => __SMTPHOST__, 'port' => __SMTPPORT__, 'auth' => __SMTPAUTH__, 'username' => __SMTPUSER__, 'password' => __SMTPPASS__));
		$mail = $smtp->send($to, $headers, $contents);

		if (PEAR::isError($mail)) {
			return $mail->getMessage();
		} else {
			return "";
		}
		*/

	} catch (Exception $e) {

		return $e->getMessage();
	}
}

function getEmailContent($content, $from, $to, $password, $login, $name)
{
	// Email Format
	// {to} - To Email Address
	// {from} - From Email Address
	// {sendDate} - Send Date
	// {sendTime} - Send Time
	// {sendDateTime} - Send Date Time
	// {login} - User Login
	// {name} - User Name
	// {password} - Login Password

	$result = $content;

	$result = str_ireplace("{to}", $to, $result);
	$result = str_ireplace("{from}", $from, $result);
	$result = str_ireplace("{sendDate}", date("Y-m-d"), $result);
	$result = str_ireplace("{sendTime}", date("H:i"), $result);
	$result = str_ireplace("{sendDateTime}", date("Y-m-d H:i"), $result);
	$result = str_ireplace("{password}", $password, $result);
	$result = str_ireplace("{login}", $login, $result);
	$result = str_ireplace("{name}", $name, $result);

	$result = str_ireplace("\r\n", "<br/>", $result);
	$result = str_ireplace("\r", "<br/>", $result);
	$result = str_ireplace("\n", "<br/>", $result);

	return $result;
}

function hashPass($pass, $salt="")
{
	return password_hash($pass, PASSWORD_DEFAULT);
	
	// return hash("sha256", $salt.$pass);
}

function verifyPass($pass, $hash, $salt="")
{
	return password_verify($pass, $hash);
	
	// return (hashPass($pass, $salt) === $hash);
}

function randomString($length)
{
	/*
	if ($_REQUEST["debug1"]==1)
	{
		return "0807a367e922";
	}
	*/

  $random= "";
  srand((double)microtime()*1000000);
  $char_list = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
  $char_list .= "abcdefghijklmnopqrstuvwxyz";
  $char_list .= "1234567890";
  // Add the special characters to $char_list if needed

  for($i = 0; $i < $length; $i++)
  {
    $random .= substr($char_list,(rand()%(strlen($char_list))), 1);
  }
  return $random;
}

function saveCookie($name, $value)
{
	setcookie($name, $value, time()+60*60*24*30, "/");
}

function clearCookie($name)
{
	setcookie($name, "", time()+60*60*24*30, "/");
}

function checkSelected($field,$value)
{
	if (is_array($_REQUEST[$field]))
	{
		foreach ($_REQUEST[$field] as $field_item)
		{
			if ($field_item==$value)
				return "selected";
		}

		return "";
	}
	else
	{
		return ($_REQUEST[$field]==$value)? "selected" : "";
	}
}

function checkChecked($field,$value)
{
	if (is_array($_REQUEST[$field]))
	{
		foreach ($_REQUEST[$field] as $field_item)
		{
			if ($field_item==$value)
			{
				return "checked";
			}
		}
		return "";
	}
	else
	{
		return ($_REQUEST[$field]==$value)? "checked" : "";
	}
}

function checkEmpty($value, $default, $quote)
{
	if ($value=="") return $default;

	return $quote.$value.$quote;
}

function copy_directory( $source, $destination ) {
	if ( is_dir( $source ) ) {
		@mkdir( $destination );
		$directory = dir( $source );
		while ( FALSE !== ( $readdirectory = $directory->read() ) ) {
			if ( $readdirectory == '.' || $readdirectory == '..' ) {
				continue;
			}
			$PathDir = $source . '/' . $readdirectory;
			if ( is_dir( $PathDir ) ) {
				copy_directory( $PathDir, $destination . '/' . $readdirectory );
				continue;
			}
			copy( $PathDir, $destination . '/' . $readdirectory );
		}

		$directory->close();
	}else {
		copy( $source, $destination );
	}
}

function getImageFileSize($file, $widthMax, $heightMax)
{
	$imageInfo = getimagesize($file);
	$width = $imageInfo[0];
	$height = $imageInfo[1];

	if (!$width || !$height)
		$ratio = 1;
	else
		$ratio = min($widthMax/$width, $heightMax/$height);

	$size["width"] = $width * $ratio;
	$size["height"] = $height * $ratio;

	return $size;
}

function getImageMaxSize($file, $widthMax, $heightMax)
{
	$size = array();
	$size["width"] = 0;
	$size["height"] = 0;
	$size["padding"] = 0;
	$size["height-container"] = $heightMax;

	$imageInfo = getimagesize($file);

	if ($imageInfo)
	{
		$width = $imageInfo[0];
		$height = $imageInfo[1];

		if ($width >= $height)
		{
			// Check the width
			if ($width > $widthMax)
				$size["width"] = $widthMax;
			else
				$size["width"] = $width;

			$ratio = $height/$width;

			$heightActual = intval($size["width"] * $ratio);

			$size["padding"] = ($heightMax - $heightActual)/2;
			$size["height-container"] = $heightMax-($size["padding"]*2);
		}
		else
		{
			// Check the height
			if ($height > $heightMax)
				$size["height"] = $heightMax;
			else
				$size["height"] = $height;
		}
	}

	return $size;
}

function startsWith($haystack, $needle)
{
    return !strncmp($haystack, $needle, strlen($needle));
}

function endsWith($haystack, $needle)
{
    $length = strlen($needle);
    if ($length == 0) {
        return true;
    }

    return (substr(strtolower($haystack), -$length) === strtolower($needle));
}

function is_date( $str ){
    $stamp = strtotime( $str );
    if (!is_numeric($stamp))
        return FALSE;
    $month = date( 'm', $stamp );
    $day   = date( 'd', $stamp );
    $year  = date( 'Y', $stamp );
    if (checkdate($month, $day, $year))
        return TRUE;
    return FALSE;
}

function mb_strtr($string, $encode)
{
	$result = "";

	foreach (mb_str_split($string) as $char)
	{
		if ($encode[$char])
			$result .= $encode[$char];
		else
			$result .= $char;
	}

	return $result;
}

function is_url_exist($url){
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_NOBODY, true);
    curl_exec($ch);
    $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    if($code == 200){
       $status = "yes";
    }else{
      $status = "no";
    }
    curl_close($ch);
   return $status;
}

/*
function mb_str_split( $string ) {
    # Split at all position not after the start: ^
    # and not before the end: $
    return preg_split('/(?<!^)(?!$)/u', $string );
}
*/

/*
function mb_strtr($str, $from, $to)
{
  return str_replace(mb_str_split($from), mb_str_split($to), $str);
}
function mb_str_split($str) {
    return preg_split('~~u', $str, null, PREG_SPLIT_NO_EMPTY);;

}
*/

?>